package book.beans;

import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.FacesContext;
import javax.inject.Named;

/**
 *
 * @author Leonard
 */
@Named
@RequestScoped
public class PlayersBean {

    private static final Logger logger =
            Logger.getLogger(PlayersBean.class.getName());
    private String playerName;
    private String playerSurname;

    /**
     * Tworzy nową instancję PlayersBean
     */
    public PlayersBean() {
    }

    public void init() {
        if (!FacesContext.getCurrentInstance().isPostback()) {
            logger.info("WYKONYWANIE AKCJI INIT");
            if (playerName != null) {
                playerName = playerName.toUpperCase();
            }
            if (playerSurname != null) {
                playerSurname = playerSurname.toUpperCase();
            }
        }
    }

    public String getPlayerName() {
        return playerName;
    }

    public void setPlayerName(String playerName) {
        logger.info("WYKONYWANIE 'setPlayerName' MUTATORA");
        this.playerName = playerName;
    }

    public String getPlayerSurname() {
        return playerSurname;
    }

    public void setPlayerSurname(String playerSurname) {
        logger.info("WYKONYWANIE 'setPlayerSurname' MUTATORA");
        this.playerSurname = playerSurname;
    }

    public void postbackAction() {
        logger.info("WYKONYWANIE POSTBACK AKCJI");
    }
}
